/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.column;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.util.Variance;
import com.terraforged.engine.world.heightmap.Levels;
import com.terraforged.engine.world.terrain.TerrainType;
import com.terraforged.mod.api.chunk.column.ColumnDecorator;
import com.terraforged.mod.api.chunk.column.DecoratorContext;
import com.terraforged.mod.api.material.state.States;
import com.terraforged.noise.util.NoiseUtil;
import net.minecraft.block.BlockState;
import net.minecraft.world.chunk.IChunk;

public class BaseDecorator
implements ColumnDecorator {
    public static final BaseDecorator INSTANCE = new BaseDecorator();
    private static final int LAVA_DEPTH = 10;
    private static final Variance LAVA_LEVEL = Variance.of(32.0, 64.0);

    @Override
    public void decorate(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        y = this.decorateFluid(chunk, context, x, y, z);
        this.fillDown(context, chunk, x, z, y, 0, (BlockState)States.STONE.get());
    }

    protected int decorateFluid(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        int lavaEnd;
        int lavaLevel;
        if (y < context.levels.waterLevel) {
            return this.fillDown(context, chunk, x, z, context.levels.waterY, y, (BlockState)States.WATER.get());
        }
        if (context.cell.terrain == TerrainType.VOLCANO_PIPE && (lavaLevel = BaseDecorator.getLavaLevel(y, context.cell, context.levels)) > 0 && lavaLevel > (lavaEnd = Math.max(5, context.levels.waterY - 10))) {
            return this.fillDown(context, chunk, x, z, lavaLevel, lavaEnd, (BlockState)States.LAVA.get());
        }
        return y;
    }

    private static int getLavaLevel(int y, Cell cell, Levels levels) {
        int regionLavaHeight = NoiseUtil.floor(LAVA_LEVEL.apply(cell.terrainRegionId));
        int lavaLevel = levels.waterLevel + regionLavaHeight;
        if (y < lavaLevel) {
            return 0;
        }
        return lavaLevel;
    }
}

